#########################################################################################
# Alessandro Bugliarelli 2023
# JLNT TCAD modeling
# PMOS INVERTER TRANSIENT OUTPUT CHARACTERISTICS - f = 1 THz - 20 NM DEVICE
# RESISTIVE LOAD WITH PULLDOWN TRANSISTOR - VD = -1.1 V
# LOGIC 0 = -1.1 V  LOGIC 1 = 0 V
#########################################################################################
Device PMOS {
	File {
		Grid		= "pmos_inverter_msh.tdr"
		Plot		= "pmos_inverter"
		Current		= "pmos_inverter"
		Parameter	= "pmos_inverter.par"
	}

	Electrode {
		{ name="Source"    Voltage=0.0 }
		{ name="Drain"     Voltage=0.0 DistResist = SchottkyResist }
		{ name="Gate"      Voltage=0.0 }
	}

	Physics{
		Fermi
		Mobility( DopingDep HighFieldSaturation ( ParameterSetName = "myHighField" ) Enormal )
		EffectiveIntrinsicDensity( Bennett )
		Recombination(
		SRH( DopingDep )
#		Band2Band (
#			Model = Hurkx
#			DensityCorrection = Local 
#			ParameterSetName = ("myBTBT") )
		)
		eQuantumPotential
		hQuantumPotential
	}

	Physics(MaterialInterface = "Silicon/SiO2"){
		Traps(
			Acceptor Level EnergyMid=-0.3 fromMidBandGap 
			Conc=4.0e11 eXsection=1e-14  hXsection=1e-14
		)
	}
}

Math{
	Extrapolate
	RelErrControl
	Digits=4
  	Notdamped=50
  	Iterations=24
  	Transient=BE
  	Method=Blocked
  	SubMethod=ParDiSo
}

Plot{
	eDensity hDensity
	eCurrent hCurrent
	ElectricField eEnormal hEnormal
	eQuasiFermi hQuasiFermi
	Potential Doping SpaceCharge
	SRH Auger 
	AvalancheGeneration
	eMobility hMobility
	DonorConcentration AcceptorConcentration
	Doping
	eVelocity hVelocity
}

File {
	Output = "@log@"
}

System {
	Vsource_pset vdd (dd 0) { dc = 0.0 }
	Vsource_pset vin (in 0) { pulse = (
		0.0       	# dc
		-1.1      	# amplitude
		10e-11    	# td
		10e-11    	# tr
		10e-11    	# tf
		40e-11    	# ton
		100e-11)   	# period 
	}

	PMOS pulldown ( "Drain" = out "Gate" = in "Source" = 0 )
	Resistor_pset rload ( dd out ){ resistance = 100e6 }
	Plot "n@node@_sys_des.plt" (time() v(in) v(out) i(pulldown,out) )
}

Solve {  
	NewCurrentPrefix="init"
	Coupled(Iterations=100){ Poisson }
	Coupled{ Poisson Electron Hole Contact Circuit }

	Quasistationary( 
	InitialStep=0.05 MaxStep=0.05 MinStep=0.0001 
	Goal{ Parameter=vdd.dc Voltage= -1.1 } 
	){ Coupled{ pulldown.poisson pulldown.electron pulldown.hole pulldown.contact circuit } }

	NewCurrentPrefix=""
	Transient (
	InitialTime=0 FinalTime=150e-11
	InitialStep=1e-11 Increment=1.3
	MaxStep=5e-10 MinStep=1e-14
	TurningPoints (
	( Condition ( Time ( 1e-10 ; 6e-10 ; 1.1e-9 ) ) Value= 1.0e-12 )
	( Condition ( Time ( Range= ( 1e-10 1.5e-10 ) ; Range= ( 8e-10 9e-10 ) ; 
	Range= ( 1.1e-9 1.2e-9 ) ) ) Value= 1.0e-11 ) )
	){ Coupled{ pulldown.poisson pulldown.electron pulldown.hole pulldown.contact circuit } }

}

